
async function __runtimeMainFunction(params) {
    const jsonData = await fetchRequest(params)

    const response = parseResponse(jsonData)

    return response;
}

async function fetchRequest(params) {
    const { requestURL, requestHeaders } = params;

    try {
        const response = await fetch(requestURL, {
            headers: requestHeaders,
            "method": "GET",
            "credentials": "include",
        });

        if (!response.ok) {
            throw new IntegrationError(
                IntegrationErrorCategory.NETWORK,
                'Google Docs API request failed',
                { httpStatus: response.status, url: requestURL }
            );
        }

        const data = await response.json();
        return data;
    } catch (error) {
        throw error;
    }
}

function parseResponse(jsonData) {
    const items = jsonData?.items || [];
    const resultList = [];

    for (const itemIndex in items) {
        const item = items[itemIndex]
        if (item.id) {
            const itemId = item.id;
            const title = item.title || "";
            resultList.push({
                itemId: itemId,
                title: title
            });
        }
    }

    return { "results": resultList };
}
