// IMPORTANT: Keep this path regex and logic in sync with:
//   • URL.isGoogleDocsDocument (Swift)
//   • ContentFetchController.fetchIntegrationOutput (Google Docs guard)
//   • IsUserGoogleDocOwner/v1.js
// If you change the pattern here, update those locations as well.
async function __runtimeMainFunction() {
    // 1. Validate Docs pathname
    const pathRegex = /^\/document\/(?:u\/(\d+)\/)?d\/([A-Za-z0-9-_]+)/;
    const match = window.location.pathname.match(pathRegex);
    if (!match) {
        throw new IntegrationError(
            IntegrationErrorCategory.VALIDATION,
            'Not on Google Docs page',
            { isBenign: true }
        );
    }
    const accountId = match[1];   // may be undefined
    const docId     = match[2];

    const exportUrl = accountId
        ? `https://docs.google.com/document/u/${accountId}/export?format=md&id=${docId}`
        : `https://docs.google.com/document/export?format=md&id=${docId}`;

    // We treat any failure (network, 4xx/5xx, signed-out redirect, etc.) as
    // “no export available” rather than throwing. Returning an empty markdown
    // string lets the Swift service exit gracefully and skip the owner check.
    let resp;
    try {
        // Attempt the export request, including credentials if any are present.
        resp = await fetch(exportUrl, { method: "GET" });
    } catch (err) {
        throw new IntegrationError(
            IntegrationErrorCategory.NETWORK,
            'Network error fetching export: ' + err.message
        );
    }
    if (!resp.ok) {
        throw new IntegrationError(
            IntegrationErrorCategory.NETWORK,
            'Export request failed',
            { httpStatus: resp.status, url: exportUrl }
        );
    }

    const markdown = await resp.text();
    return { markdown };
}
