
async function __runtimeMainFunction(params) {
    const response = await fetchRequest(params)
    const jsonData = await response.json();
    const parsedResponse = await parseResponse({ response, jsonData })
    return parsedResponse;
}

async function fetchRequest(params) {
    const url = 'https://accounts.google.com/ListAccounts';

    // Cookie headers will be automatically set.
    const headers = {
        "accept": "*/*",
    };

    try {
        // I've stripped out non-essential arguments.
        const response = await fetch(url, {
            headers: headers,
            body: "{}",
            "method": "POST",
            "mode": "cors",
            "credentials": "include",
            "referrerPolicy": "strict-origin-when-cross-origin",
        });

        if (!response.ok) {
            throw new IntegrationError(
                IntegrationErrorCategory.NETWORK,
                'Failed to fetch Google accounts',
                { httpStatus: response.status, url: url }
            );
        }

        return response;
    } catch (error) {
        throw error;
    }
}

function parseResponse({ response, jsonData }) {
    const accountList = [];

    function isSafeArray(value) {
        return typeof value === 'object' && value !== null && Array.isArray(value);
    };
    function isSafeString(value) {
        return typeof value === 'string' && value !== null;
    };

    const outerArray = jsonData;
    if (isSafeArray(outerArray)) {
        const accountsArray = outerArray[1];
        if (isSafeArray(accountsArray)) {
            for (const accountIndex in accountsArray) {
                const accountArray = accountsArray[accountIndex];
                if (isSafeArray(accountArray)) {
                    const name = accountArray[2];
                    const email = accountArray[3];
                    if (name &&
                        isSafeString(name) &&
                        email &&
                        isSafeString(email)) {
                        accountList.push({
                            index: accountIndex,
                            name,
                            email
                        });
                    }
                }
            }
        }
    }

    return { "accounts": accountList };
}
