// arc/services/ai/public/mojom/ai_service.mojom-c_api.h is auto generated by mojom_bindings_generator.py, do not edit



#pragma once

#include <stdbool.h>
#include <stdint.h>

#ifdef __cplusplus
namespace mojoc {
#endif // __cplusplus


typedef enum {
  AIServiceTypeNone = - 1,
  AIServiceTypeClassification = 0,
  AIServiceTypeEmbedding = 1,
  AIServiceTypeInference = 2,
} AIServiceType;

typedef enum {
  AIServiceErrorNone = - 1,
  AIServiceErrorIllegalState = 0,
  AIServiceErrorInvalidParameter = 1,
  AIServiceErrorNotImplemented = 2,
  AIServiceErrorNotInitialized = 3,
  AIServiceErrorAlreadyInitialized = 4,
  AIServiceErrorInvalidLibraryPath = 5,
  AIServiceErrorLibraryNotFound = 6,
  AIServiceErrorLibraryMissingRequiredSymbols = 7,
  AIServiceErrorCannotDownloadModel = 8,
  AIServiceErrorOtherError = 9,
} AIServiceError;

typedef enum {
  AIEmbeddingSupportedModelNone = - 1,
  AIEmbeddingSupportedModelGteSmall = 0,
  AIEmbeddingSupportedModelGteBase = 1,
  AIEmbeddingSupportedModelGteLarge = 2,
  AIEmbeddingSupportedModelAlibabaGteBase = 3,
} AIEmbeddingSupportedModel;

typedef enum {
  AIEmbeddingMethodNone = - 1,
  AIEmbeddingMethodOnnxRuntime = 0,
  AIEmbeddingMethodCoreML = 1,
  AIEmbeddingMethodMLX = 2,
  AIEmbeddingMethodRemote = 3,
} AIEmbeddingMethod;

typedef enum {
  AIInferenceModelTypeNone = - 1,
  AIInferenceModelTypePhi3_5 = 0,
  AIInferenceModelTypeLlama_3_2 = 1,
  AIInferenceModelTypeGemma2b = 2,
  AIInferenceModelTypeQwen205b = 3,
  AIInferenceModelTypeOpenelm270m = 4,
  AIInferenceModelTypeDirectory = 5,
} AIInferenceModelType;

typedef struct {
  uint16_t id;
  uint64_t pointer;
} UserData;

typedef struct {
  const char* string;
  unsigned int length;
} String;

typedef struct {
  const float* begin;
  unsigned int length;
} FloatArray;

typedef struct {
  AIEmbeddingMethod method;
  AIEmbeddingSupportedModel model;
} AIEmbeddingConfiguration;

typedef struct {
  AIServiceType type;
  String displayName;
  String libraryPath;
  String libraryVersion;
  String appEnvironment;
  String fullAppVersion;
  int8_t maxRetries;
  double timeoutSeconds;
} AIServiceConfiguration;

typedef struct {
  AIInferenceModelType type;
  String directory;
} AIInferenceModel;

typedef struct {
  int32_t maxTokens;
  int16_t streamAfterEveryNTokens;
} AIStreamedInferenceConfiguration;

typedef struct {
  String modelFilePath;
  String loraConfigJson;
  String configFilePath;
  String classifierHeadFilePath;
  int16_t numClasses;
} AIDistilBertClassifier;

typedef struct {
  FloatArray classification;
  unsigned int classificationLength;
} Classification;

typedef struct {
  FloatArray* embeddings;
  unsigned int embeddingsLength;
} Embeddings;

typedef struct {
  bool isLoaded;
} Loaded;


typedef struct {
  enum AIErrorOrServiceTypeEnum {
    AIErrorOrServiceTypeEnumService_type,
    AIErrorOrServiceTypeEnumError,
  } type;
  union AIErrorOrServiceTypeUnion {
    AIServiceType serviceType;
    AIServiceError error;
  } value;
} AIErrorOrServiceType;

typedef struct {
  enum AIErrorOrClassificationEnum {
    AIErrorOrClassificationEnumClassification,
    AIErrorOrClassificationEnumError,
  } type;
  union AIErrorOrClassificationUnion {
    Classification classification;
    AIServiceError error;
  } value;
} AIErrorOrClassification;

typedef struct {
  enum AIErrorOrEmbeddingsEnum {
    AIErrorOrEmbeddingsEnumEmbeddings,
    AIErrorOrEmbeddingsEnumError,
  } type;
  union AIErrorOrEmbeddingsUnion {
    Embeddings embeddings;
    AIServiceError error;
  } value;
} AIErrorOrEmbeddings;

typedef struct {
  enum AIErrorOrLoadedEnum {
    AIErrorOrLoadedEnumLoaded,
    AIErrorOrLoadedEnumError,
  } type;
  union AIErrorOrLoadedUnion {
    Loaded loaded;
    AIServiceError error;
  } value;
} AIErrorOrLoaded;

// Forward declare interfaces
typedef void* AIServiceHandle;
typedef void* AIStreamedInferenceListenerHandle;
typedef struct AIStreamedInferenceListener_ AIStreamedInferenceListener;

// Definition of AIService
#ifdef __cplusplus
extern "C" {
#endif // __cplusplus
  AIServiceHandle AIService_Create();
#ifdef __cplusplus
}
#endif // __cplusplus

// Methods in the AIService
#ifdef __cplusplus
extern "C" {
#endif // __cplusplus
  typedef void (*InitializeCallback)(AIServiceError, UserData);
  typedef void (*Initialize_FnPtr_t)(AIServiceHandle handle, AIServiceConfiguration* config, InitializeCallback closure, UserData user_data);
  void AIService_Initialize(AIServiceHandle handle, AIServiceConfiguration* config, InitializeCallback closure, UserData user_data);
#ifdef __cplusplus
}
#endif // __cplusplus
#ifdef __cplusplus
extern "C" {
#endif // __cplusplus
  typedef void (*SetUserCallback)(AIServiceError, UserData);
  typedef void (*SetUser_FnPtr_t)(AIServiceHandle handle, String id, String email, SetUserCallback closure, UserData user_data);
  void AIService_SetUser(AIServiceHandle handle, String id, String email, SetUserCallback closure, UserData user_data);
#ifdef __cplusplus
}
#endif // __cplusplus
#ifdef __cplusplus
extern "C" {
#endif // __cplusplus
  typedef void (*EnableDataDogTracingCallback)(AIServiceError, UserData);
  typedef void (*EnableDataDogTracing_FnPtr_t)(AIServiceHandle handle, int8_t sampling_rate, EnableDataDogTracingCallback closure, UserData user_data);
  void AIService_EnableDataDogTracing(AIServiceHandle handle, int8_t sampling_rate, EnableDataDogTracingCallback closure, UserData user_data);
#ifdef __cplusplus
}
#endif // __cplusplus
#ifdef __cplusplus
extern "C" {
#endif // __cplusplus
  typedef void (*TypeCallback)(AIErrorOrServiceType*, UserData);
  typedef void (*Type_FnPtr_t)(AIServiceHandle handle, TypeCallback closure, UserData user_data);
  void AIService_Type(AIServiceHandle handle, TypeCallback closure, UserData user_data);
#ifdef __cplusplus
}
#endif // __cplusplus
#ifdef __cplusplus
extern "C" {
#endif // __cplusplus
  typedef void (*WaitForDebuggerToAttachCallback)(UserData);
  typedef void (*WaitForDebuggerToAttach_FnPtr_t)(AIServiceHandle handle, uint16_t seconds, WaitForDebuggerToAttachCallback closure, UserData user_data);
  void AIService_WaitForDebuggerToAttach(AIServiceHandle handle, uint16_t seconds, WaitForDebuggerToAttachCallback closure, UserData user_data);
#ifdef __cplusplus
}
#endif // __cplusplus
#ifdef __cplusplus
extern "C" {
#endif // __cplusplus
  typedef void (*CrashCallback)(UserData);
  typedef void (*Crash_FnPtr_t)(AIServiceHandle handle, CrashCallback closure, UserData user_data);
  void AIService_Crash(AIServiceHandle handle, CrashCallback closure, UserData user_data);
#ifdef __cplusplus
}
#endif // __cplusplus
#ifdef __cplusplus
extern "C" {
#endif // __cplusplus
  typedef void (*UpdateFeatureFlagsCallback)(bool, UserData);
  typedef void (*UpdateFeatureFlags_FnPtr_t)(AIServiceHandle handle, String feature_flags_as_json, UpdateFeatureFlagsCallback closure, UserData user_data);
  void AIService_UpdateFeatureFlags(AIServiceHandle handle, String feature_flags_as_json, UpdateFeatureFlagsCallback closure, UserData user_data);
#ifdef __cplusplus
}
#endif // __cplusplus
#ifdef __cplusplus
extern "C" {
#endif // __cplusplus
  typedef void (*GetEmbeddingsForCallback)(AIErrorOrEmbeddings*, UserData);
  typedef void (*GetEmbeddingsFor_FnPtr_t)(AIServiceHandle handle, String* inputs, unsigned int inputs_length, AIEmbeddingConfiguration* config, GetEmbeddingsForCallback closure, UserData user_data);
  void AIService_GetEmbeddingsFor(AIServiceHandle handle, String* inputs, unsigned int inputs_length, AIEmbeddingConfiguration* config, GetEmbeddingsForCallback closure, UserData user_data);
#ifdef __cplusplus
}
#endif // __cplusplus
#ifdef __cplusplus
extern "C" {
#endif // __cplusplus
  typedef void (*LoadInferenceModelCallback)(AIServiceError, UserData);
  typedef void (*LoadInferenceModel_FnPtr_t)(AIServiceHandle handle, AIInferenceModel* model, LoadInferenceModelCallback closure, UserData user_data);
  void AIService_LoadInferenceModel(AIServiceHandle handle, AIInferenceModel* model, LoadInferenceModelCallback closure, UserData user_data);
#ifdef __cplusplus
}
#endif // __cplusplus
#ifdef __cplusplus
extern "C" {
#endif // __cplusplus
  typedef void (*GetStreamedInferenceForCallback)(AIServiceError, UserData);
  typedef void (*GetStreamedInferenceFor_FnPtr_t)(AIServiceHandle handle, String prompt, AIStreamedInferenceConfiguration* config, AIInferenceModel* model, AIStreamedInferenceListenerHandle listener, AIStreamedInferenceListener dispatch_table, GetStreamedInferenceForCallback closure, UserData user_data);
  void AIService_GetStreamedInferenceFor(AIServiceHandle handle, String prompt, AIStreamedInferenceConfiguration* config, AIInferenceModel* model, AIStreamedInferenceListenerHandle listener, AIStreamedInferenceListener dispatch_table, GetStreamedInferenceForCallback closure, UserData user_data);
#ifdef __cplusplus
}
#endif // __cplusplus
#ifdef __cplusplus
extern "C" {
#endif // __cplusplus
  typedef void (*LoadClassifierCallback)(AIServiceError, UserData);
  typedef void (*LoadClassifier_FnPtr_t)(AIServiceHandle handle, AIDistilBertClassifier* classifier, LoadClassifierCallback closure, UserData user_data);
  void AIService_LoadClassifier(AIServiceHandle handle, AIDistilBertClassifier* classifier, LoadClassifierCallback closure, UserData user_data);
#ifdef __cplusplus
}
#endif // __cplusplus
#ifdef __cplusplus
extern "C" {
#endif // __cplusplus
  typedef void (*IsClassifierLoadedCallback)(AIErrorOrLoaded*, UserData);
  typedef void (*IsClassifierLoaded_FnPtr_t)(AIServiceHandle handle, AIDistilBertClassifier* classifier, IsClassifierLoadedCallback closure, UserData user_data);
  void AIService_IsClassifierLoaded(AIServiceHandle handle, AIDistilBertClassifier* classifier, IsClassifierLoadedCallback closure, UserData user_data);
#ifdef __cplusplus
}
#endif // __cplusplus
#ifdef __cplusplus
extern "C" {
#endif // __cplusplus
  typedef void (*GetClassificationForCallback)(AIErrorOrClassification*, UserData);
  typedef void (*GetClassificationFor_FnPtr_t)(AIServiceHandle handle, String input, AIDistilBertClassifier* classifier, GetClassificationForCallback closure, UserData user_data);
  void AIService_GetClassificationFor(AIServiceHandle handle, String input, AIDistilBertClassifier* classifier, GetClassificationForCallback closure, UserData user_data);
#ifdef __cplusplus
}
#endif // __cplusplus


// Methods in the AIStreamedInferenceListener
#ifdef __cplusplus
extern "C" {
#endif // __cplusplus
  typedef void (*InferenceInProgress_FnPtr_t)(AIStreamedInferenceListenerHandle handle, String data, UserData user_data);
#ifdef __cplusplus
}
#endif // __cplusplus

struct AIStreamedInferenceListener_ {
  InferenceInProgress_FnPtr_t inferenceInProgress;
};

typedef struct {
  enum AIServiceSymbolType {
    AIServiceSymbolTypeInitialize,
    AIServiceSymbolTypeSetUser,
    AIServiceSymbolTypeEnableDataDogTracing,
    AIServiceSymbolTypeType,
    AIServiceSymbolTypeWaitForDebuggerToAttach,
    AIServiceSymbolTypeCrash,
    AIServiceSymbolTypeUpdateFeatureFlags,
    AIServiceSymbolTypeGetEmbeddingsFor,
    AIServiceSymbolTypeLoadInferenceModel,
    AIServiceSymbolTypeGetStreamedInferenceFor,
    AIServiceSymbolTypeLoadClassifier,
    AIServiceSymbolTypeIsClassifierLoaded,
    AIServiceSymbolTypeGetClassificationFor,
  } type;

  union AIServiceSymbolValue {
    Initialize_FnPtr_t Initialize;
    SetUser_FnPtr_t SetUser;
    EnableDataDogTracing_FnPtr_t EnableDataDogTracing;
    Type_FnPtr_t Type;
    WaitForDebuggerToAttach_FnPtr_t WaitForDebuggerToAttach;
    Crash_FnPtr_t Crash;
    UpdateFeatureFlags_FnPtr_t UpdateFeatureFlags;
    GetEmbeddingsFor_FnPtr_t GetEmbeddingsFor;
    LoadInferenceModel_FnPtr_t LoadInferenceModel;
    GetStreamedInferenceFor_FnPtr_t GetStreamedInferenceFor;
    LoadClassifier_FnPtr_t LoadClassifier;
    IsClassifierLoaded_FnPtr_t IsClassifierLoaded;
    GetClassificationFor_FnPtr_t GetClassificationFor;
  } value;
} AIServiceSymbol;


typedef struct {
  enum AIStreamedInferenceListenerSymbolType {
    AIStreamedInferenceListenerSymbolTypeInferenceInProgress,
  } type;

  union AIStreamedInferenceListenerSymbolValue {
    InferenceInProgress_FnPtr_t InferenceInProgress;
  } value;
} AIStreamedInferenceListenerSymbol;



const char kSymbolAIService_Create[] = "AIService_Create";
const char kSymbolAIService_Initialize[] = "AIService_Initialize";
const char kSymbolAIService_SetUser[] = "AIService_SetUser";
const char kSymbolAIService_EnableDataDogTracing[] = "AIService_EnableDataDogTracing";
const char kSymbolAIService_Type[] = "AIService_Type";
const char kSymbolAIService_WaitForDebuggerToAttach[] = "AIService_WaitForDebuggerToAttach";
const char kSymbolAIService_Crash[] = "AIService_Crash";
const char kSymbolAIService_UpdateFeatureFlags[] = "AIService_UpdateFeatureFlags";
const char kSymbolAIService_GetEmbeddingsFor[] = "AIService_GetEmbeddingsFor";
const char kSymbolAIService_LoadInferenceModel[] = "AIService_LoadInferenceModel";
const char kSymbolAIService_GetStreamedInferenceFor[] = "AIService_GetStreamedInferenceFor";
const char kSymbolAIService_LoadClassifier[] = "AIService_LoadClassifier";
const char kSymbolAIService_IsClassifierLoaded[] = "AIService_IsClassifierLoaded";
const char kSymbolAIService_GetClassificationFor[] = "AIService_GetClassificationFor";

static const char* Symbols[] = {
  kSymbolAIService_Create,
  kSymbolAIService_Initialize,
  kSymbolAIService_SetUser,
  kSymbolAIService_EnableDataDogTracing,
  kSymbolAIService_Type,
  kSymbolAIService_WaitForDebuggerToAttach,
  kSymbolAIService_Crash,
  kSymbolAIService_UpdateFeatureFlags,
  kSymbolAIService_GetEmbeddingsFor,
  kSymbolAIService_LoadInferenceModel,
  kSymbolAIService_GetStreamedInferenceFor,
  kSymbolAIService_LoadClassifier,
  kSymbolAIService_IsClassifierLoaded,
  kSymbolAIService_GetClassificationFor
};
#ifdef __cplusplus
}  // namespace mojoc
#endif // __cplusplus
