#!/bin/bash

APP_BUNDLE_ID="$1"
shift
APP_PATH="$1"
shift
ARGS="$@"

SLEEP_TIME=0.25
TIME_LIMIT=300
START_TIME=$(date +%s)

LOG_FILE_DIR="/tmp/arc_restart_service"
LOG_FILE="$LOG_FILE_DIR/RestartClientService.$(date +%s).log"

function log {
    echo "[$(date)] $1" >> "$LOG_FILE"
}

# Init log
mkdir -p "$LOG_FILE_DIR"
echo "" > "$LOG_FILE"

log "Bundle ID: $APP_BUNDLE_ID"
log "App Path: $APP_PATH"
log "Log File: $LOG_FILE"
log "Args: $ARGS"

function launch_app {
    open -a "${APP_PATH}" --args ${ARGS}
}

function exit_if_not_allowed {
    SHOULD_BE_ALLOWED=$(defaults read $APP_BUNDLE_ID restartClientServiceShouldBeAllowed 2>/dev/null)
    STATUS=$?
    if [ $STATUS -ne 0 ] ; then
        log "Exiting because wasn't able to verify if it's allowed"
        exit $STATUS
    fi
    if [ $SHOULD_BE_ALLOWED -ne "1" ] ; then
        log "Exiting because wasn't allowed to run"
        exit 0
    fi
}

function exit_if_timed_out {
    elapsed=$(expr $(date +%s) - $START_TIME)
    if [ $elapsed -gt $TIME_LIMIT ] ; then
        log "Exiting because it timed out after $elapsed s."
        exit 0
    fi
}

while true; do
    exit_if_not_allowed
    exit_if_timed_out

    isStillRunning=$(osascript -e "tell application \"System Events\" to exists (processes where bundle identifier is \"$APP_BUNDLE_ID\")")
    log "Is app still running: ${isStillRunning}"
    if [ "${isStillRunning}" == "false" ] ; then
        log "Application is not running. Attempting to start..."
        launch_app
        exit 0
    fi
    sleep $SLEEP_TIME
done
