async function __runtimeMainFunction() {
    // Early-exit if `ytInitialPlayerResponse` is missing.
    // This global has been present on YouTube watch pages since ~2017 and is
    // relied upon by many scraping tools (youtube-dl, yt-dlp, pytube, etc.) to
    // identify a standard video page and access metadata. If it’s absent, we’re
    // almost certainly not on a normal watch page, so further processing would be
    // wasted.
    if (typeof ytInitialPlayerResponse === 'undefined' || !ytInitialPlayerResponse) {
        throw new IntegrationError(
            IntegrationErrorCategory.VALIDATION,
            'Not on YouTube watch page',
            { isBenign: true }
        );
    }

    const videoDetails = ytInitialPlayerResponse.videoDetails

    return {
        title: videoDetails.title,
        author: videoDetails.author,
        description: videoDetails.shortDescription,
        viewCount: parseInt(videoDetails.viewCount),
        publishDate: ytInitialPlayerResponse.microformat?.playerMicroformatRenderer?.publishDate
    }
}
