async function __runtimePreloadFunction() {
    console.log("[Main] googleDriveFiles __runtimePreloadFunction()...");

    // Add a capture rule.
    // NOTE: We need to capture _XHR_ requests, not fetch() requests.
    __DiaIntegrationUtils.captureXHRRequests({
        identifier: "googleDriveFiles",
        urlRegex: "/drive/v2internal/files"
    });
}

async function __runtimeMainFunction(args) {
    return new Promise((resolve, reject) => {
        console.log("[Main] Subscribing for googleDriveFiles requests...");

        __DiaIntegrationUtils.subscribeToCapturedXHRRequests("googleDriveFiles", function(record) {
            console.log("[gDocs] Intercepted XHR request:", record.url);
            const request = parseRecord(record);
            resolve({ request });
        });
    });
}

function parseRecord(record) {
    // TODO: We could verify types.
    const url = record.url;
    const method = record.method;
    const requestHeaders = {};
    for (const key in record.requestHeaders) {
        requestHeaders[key] = record.requestHeaders[key];
    }
    const responseHeaders = {};
    for (const key in record.responseHeaders) {
        responseHeaders[key] = record.responseHeaders[key];
    }
    const requestBody = record.requestBody;
    const responseBody = record.responseBody;
    return {
        url,
        method,
        requestHeaders,
        requestBody,
        responseHeaders,
        responseBody,
    };
}
